/*
 * XFCE plugin for the MOC player
 * 
 * Control the MOC (Media On Console) player from the XFCE panel!
 * 
 * Author: Jakub Krauz
 * E-mail: jakub.krauz@volny.cz
 * Univerzity of West Bohemia
 * Department of Computer Science and Engineering
 * Pilsen, 2012
 */

#ifndef __PLUGIN_H__
#define __PLUGIN_H__

#include "settings.h"


/* plugin structure */
typedef struct
{
    XfcePanelPlugin *plugin;

    /* panel widgets */
    GtkWidget       *ebox;
    GtkWidget       *hvbox;
    GtkWidget       *bt_box;
    GtkWidget       *menu_box;

    /* settings */
    gboolean buttons_in_panel;
    char icon_color[MAX_COLOR_LEN];
}
MocPlugin;


/* function prototypes */

void create_control_widgets(MocPlugin* moc_plugin);
void save_settings(MocPlugin* mocp_plugin);
void load_settings(MocPlugin* mocp_plugin);


#endif
